@ECHO OFF
REM Hotfix Reporter batch file
REM 9-10-01 KJS
REM Copyright (C) 2001 Maximized Software.  All rights reserved.
REM Version 3.2b2
REM Version number changed 9-10-01 for version 3.2b1; functionally identical to 1.0
REM Changed sort to use redirected input, 9-10-01 ver 3.2b2
REM Information on this product is available at:
REM http://www.maximized.com/freeware/hotfixreporter/

REM Run this batch file to scan your system and display the results in HTML.
REM No parameters are required (or supported) for this batch file.
REM Please be careful if you modify this file!


REM First, make sure that the required files exist
IF NOT EXIST HfNetChk.EXE GOTO FilesMissing
IF NOT EXIST Tab2Html.EXE GOTO FilesMissing

REM Next, make a backup copy of any existing result files
ECHO Y | COPY cur-orig.txt old-orig.txt > NUL:
ECHO Y | COPY cur-sort.txt old-sort.txt > NUL:

REM Now, run the HFNetChk tool and save its output.
REM You can modify its parameters if you desire, but be
REM sure to keep the "-o tab" parameter and the redirection
REM of the output.
hfnetchk -o tab > cur-orig.txt

REM Sort the output (in reverse order to show the newest bulletins first)
sort /R < cur-orig.txt > cur-sort.txt

REM Now call Tab2Html to generate an HTML equivalent version of the results
Tab2Html
IF ERRORLEVEL 1 GOTO BadTab2Html

REM Finally, display the results
start results.htm

REM Done; skip over error handlers
GOTO Done


:FilesMissing
ECHO Error!
IF NOT EXIST HfNetChk.EXE ECHO HfNetChk.EXE is missing
IF NOT EXIST Tab2Html.EXE ECHO Tab2Html.EXE is missing
ECHO Tab2Html.EXE must be in the same directory as HfNetChk.EXE
ECHO The current directory is:
CD
ECHO Please make sure the Microsoft HfNetChk tool is installed
ECHO Please re-install Hotfix Reporter if necessary
ECHO More info is available at:
ECHO   http://www.maximized.com/freeware/hotfixreporter/
ECHO Pressing any key will exit
PAUSE
GOTO Done

:BadTab2Html
ECHO Error!
ECHO Tab2Html.EXE could not write the results to a file named
ECHO "results.htm".  Please make sure that the current user has
ECHO correct permissions for the current directory:
CD
ECHO Pressing any key will exit
PAUSE
GOTO Done

:Done
REM End.
